# Cuadro VII.1
# Contraste de homogeneidad con X^2 y test G.

########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro VII.1.V.csv",encoding="latin1")

# Seleccin de las variables de inters
varInteres<-c("Grado.de.fumador","Padres.Fumadores")
#varInteres<-c("Sexo","Grado.de.fumador")  

# Seleccin de las variables de agrupacin.
#varAgrupa<-NULL
#varAgrupa<-c("Sexo")
#varAgrupa<-c("Sexo","Centro.de.trabajo")
varAgrupa<-c("Centro.de.trabajo")

# Tipos de pruebas a realizar
# 1. Prueba chi-cuadrado.
# 2. Prueba G sin correccin de Williams.
# 3. Prueba G con correccin de Williams.
# 4. Prueba chi-cuadrado con correccin de Yates (Slo para tablas 2x2).
# 5. Prueba "exacta" de Fisher (Slo para tablas 2x2).

pruebas<-c(1,2,3)

# Nombre del archivo de salida con los resultados.
nomSalida<-"Salida Cuadro VII.1.V.txt"

########################################################
# Seccin que realiza el procedimiento
########################################################


# Log-likelihood tests of independence & goodness of fit
# Does Williams' and Yates' correction
#
# G & q calculation from Sokal & Rohlf (1995) Biometry 3rd ed.
# TOI Yates' correction taken from Mike Camann's 2x2 G-test fn.
# GOF Yates' correction as described in Zar (2000)
# more stuff taken from ctest's chisq.test()
#
# ToDo:
# 1) Beautify
# 2) Add warnings for violations
# 3) Make appropriate corrections happen by default
#
# V3.3 Pete Hurd Sept 29 2001. phurd@ualberta.ca

g.test <- function(x, y = NULL, correct="none",
  p = rep(1/length(x), length(x)))
{
  DNAME <- deparse(substitute(x))
  if (is.data.frame(x)) x <- as.matrix(x)
  if (is.matrix(x)) {
    if (min(dim(x)) == 1) 
      x <- as.vector(x)
  }
  if (!is.matrix(x) && !is.null(y)) {
    if (length(x) != length(y)) 
      stop("x and y must have the same length")
    DNAME <- paste(DNAME, "and", deparse(substitute(y)))
    OK <- complete.cases(x, y)
    x <- as.factor(x[OK])
    y <- as.factor(y[OK])
    if ((nlevels(x) < 2) || (nlevels(y) < 2)) 
      stop("x and y must have at least 2 levels")
    x <- table(x, y)
  }
  if (any(x < 0) || any(is.na(x))) 
    stop("all entries of x must be nonnegative and finite")
  if ((n <- sum(x)) == 0) 
    stop("at least one entry of x must be positive")
  #If x is matrix, do test of independence
  if (is.matrix(x)) {
    #Test of Independence
    nrows<-nrow(x)
    ncols<-ncol(x)
    if (correct=="yates"){ # Do Yates' correction?
      if(dim(x)[1]!=2 || dim(x)[2]!=2) # check for 2x2 matrix
        stop("Yates' correction requires a 2 x 2 matrix")
      if((x[1,1]*x[2,2])-(x[1,2]*x[2,1]) > 0)
        {
          x[1,1] <- x[1,1] - 0.5
          x[2,2] <- x[2,2] - 0.5
          x[1,2] <- x[1,2] + 0.5
          x[2,1] <- x[2,1] + 0.5
        }
      else
        {
          x[1,1] <- x[1,1] + 0.5
          x[2,2] <- x[2,2] + 0.5
          x[1,2] <- x[1,2] - 0.5
          x[2,1] <- x[2,1] - 0.5
        }
    }

    sr <- apply(x,1,sum)
    sc <- apply(x,2,sum)
    E <- outer(sr,sc, "*")/n
      # calculate G
      g <- 0
      for (i in 1:nrows){
        for (j in 1:ncols){
          if (x[i,j] != 0) g <- g + x[i,j] * log(x[i,j]/E[i,j])
        }
      }
      q <- 1
      if (correct=="williams"){ # Do Williams' correction
        row.tot <- col.tot <- 0    
        for (i in 1:nrows){ row.tot <- row.tot + 1/(sum(x[i,])) }
        for (j in 1:ncols){ col.tot <- col.tot + 1/(sum(x[,j])) }
        q <- 1+ ((n*row.tot-1)*(n*col.tot-1))/(6*n*(ncols-1)*(nrows-1))
      }
      STATISTIC <- G <- 2 * g / q
      PARAMETER <- (nrow(x)-1)*(ncol(x)-1)
      PVAL <- 1-pchisq(STATISTIC,df=PARAMETER)
      if(correct=="none")
        METHOD <- "Log likelihood ratio (G-test) test of independence without correction"
      if(correct=="williams")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Williams' correction"
      if(correct=="yates")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Yates' correction"
  }
  else {
    # x is not a matrix, so we do Goodness of Fit
    METHOD <- "Log likelihood ratio (G-test) goodness of fit test"
    if (length(x) == 1) 
      stop("x must at least have 2 elements")
    if (length(x) != length(p)) 
      stop("x and p must have the same number of elements")
    E <- n * p
    
    if (correct=="yates"){ # Do Yates' correction
      if(length(x)!=2)
        stop("Yates' correction requires 2 data values")
      if ( (x[1]-E[1]) > 0.25) {
        x[1] <- x[1]-0.5
        x[2] <- x[2]+0.5
      }
      else if ( (E[1]-x[1]) > 0.25){
        x[1] <- x[1]+0.5
        x[2] <- x[2]-0.5
      }
    }
    names(E) <- names(x)
    g <- 0
    for (i in 1:length(x)){
      if (x[i] != 0) g <- g + x[i] * log(x[i]/E[i])
    }
    q <- 1
    if (correct=="williams"){ # Do Williams' correction
      q <- 1+(length(x)+1)/(6*n)
    }
    STATISTIC <- G <- 2*g/q
    PARAMETER <- length(x) - 1
    PVAL <- pchisq(STATISTIC, PARAMETER, lower = FALSE)
  }
  names(STATISTIC) <- "Log likelihood ratio statistic (G)"
  names(PARAMETER) <- "X-squared df"
  names(PVAL) <- "p.value"
  structure(list(statistic=STATISTIC,parameter=PARAMETER,p.value=PVAL,
            method=METHOD,data.name=DNAME, observed=x, expected=E),
            class="htest")
}

# Autor: Marc Schwartz
cochranq.test <- function(mat)
{
  k <- ncol(mat)

  C <- sum(colSums(mat) ^ 2)
  R <- sum(rowSums(mat) ^ 2)
  T <- sum(rowSums(mat))


  num <- (k - 1) * ((k * C) - (T ^ 2))
  den <- (k * T) - R

  Q <- num / den

  df <- k - 1
  names(df) <- "df"
  names(Q) <- "Cochran's Q"

  p.val <- pchisq(Q, df, lower = FALSE)

  QVAL <- list(statistic = Q, parameter = df, p.value = p.val,

               method = "Cochran's Q Test for Dependent Samples",
               data.name = deparse(substitute(mat)))

  class(QVAL) <- "htest"
  return(QVAL)
} 



tablaDobleEntrada<-function(datos,varInteres,pruebas){
  tbl1<-table(datos[,varInteres])
  listaPruebas<-NULL
  for (i in pruebas){
    if (i==1) listaPruebas<-c(listaPruebas,list(chisq.test(tbl1,correct=FALSE)))
    if (i==2) listaPruebas<-c(listaPruebas,list(g.test(tbl1)))
    if (i==3) listaPruebas<-c(listaPruebas,list(g.test(tbl1,correct="williams")))
    if (i==4) listaPruebas<-c(listaPruebas,list(chisq.test(tbl1,correct=TRUE)))
    if (i==5) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1)))
    if (i==6) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1,alternative="less")))
    if (i==7) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1,alternative="greater")))
    if (i==8) {
              datos<-datos[,varInteres]
              tbl1<-tapply(datos[,1],datos[,2],mean)
              tbl1<-cbind(tbl1,tapply(datos[,1],datos[,2],sd))
              tbl1<-as.table(tbl1)
              colnames(tbl1)<-c("medias","desv.est")
              rownames(tbl1)<-paste(names(datos)[2],row.names(tbl1))
              varInt<-datos[,1]
              varFact<-datos[,2]
              varBloque<-datos[,3]
              listaPruebas<-c(listaPruebas,list(friedman.test(varInt,factor(varFact),factor(varBloque))))
              }
     if (i==9) listaPruebas<-c(listaPruebas,list(mcnemar.test(tbl1,correct=FALSE)))
     if (i==10) listaPruebas<-c(listaPruebas,list(mcnemar.test(tbl1,correct=TRUE)))
     if (i==11){ 
               datos<-datos[,varInteres]
               niv1<-levels(datos[,1])[1]
               niv2<-levels(datos[,1])[2]
               datos<-(datos==niv1)*1
               total<-apply(datos,2,length)
               tbl1<-apply(datos,2,sum)/total*100
               tbl1<-cbind(tbl1,100-tbl1)
               colnames(tbl1)<-c(paste("Porcentaje",niv1),paste("Porcentaje",niv2))
               listaPruebas<-c(listaPruebas,list(cochranq.test(datos)))
               }
  }
  return(list(tabla=tbl1,listaPruebas=listaPruebas))
}

if (length(varInteres)!=2 & !any((c(8,11) %in% pruebas))) stop("Deben ser exactamente dos variables de inters")
if (length(varInteres)!=3 & (8 %in% pruebas)) stop("Para la prueba de Friedman se deben tener TRES variables: Rta, Factor y Bloque")
if (sum(varInteres %in% varAgrupa)>0) stop("Las variables de inters deben ser diferentes a las de agrupacin")

if (is.null(varAgrupa)){ 
    listaR<-tablaDobleEntrada(datos,varInteres,pruebas)
}else{
    lista1<-split(datos,datos[,varAgrupa])
    listaR<-lapply(lista1,tablaDobleEntrada,varInteres,pruebas)
}

if(!is.null(nomSalida)){
 sink(nomSalida)
 print(listaR)
 sink()
}

########################################################
# Seccin que muestra los resultados
########################################################


listaR
